<?php
session_start();
include_once 'include/connect.php';
include 'include/script.php';
include 'include/head.php';
?>

<body>

	<!-- Wrapper -->
	<div id="wrapper">

		<!-- Header -->
		<?php include 'include/header.php'; ?>

		<!-- Menu -->
		<?php
		include 'include/menu.php';

		?>

		<!-- Main -->
		<div id="main">
			<!-- Post -->
			<article class="post">
				<header>
					<div class="title">
						<h2><a href="#">
								<?= $post['header'] ?>
							</a></h2>
						<p>
							<?= $post['subheader'] ?>
						</p>
					</div>
					<div class="meta">
						<time class="published" datetime="<?= $post['datepost'] ?>">
							<?= $post['datepost'] ?>
						</time>
						<a href="user.php?author=<?= $post['user_id'] ?>" class="author"><span class="name">
								<?= $user['fullname'] ?>
							</span><img src="<?= $user['avatar'] ?>" alt="Avatar of <?= $user['fullname'] ?>" /></a>
					</div>
				</header>
				<span class="image featured"><img src="<?= $post['photo'] ?>" alt="" /></span>
				<p>
					<?= $post['anons'] ?>
				</p>
				<p>
					<?= $post['post'] ?>
				</p>
				<footer>
					<?php

					// Количество лайков
					$likes = mysqli_query($link, "SELECT COUNT(id) as id FROM `liked` WHERE `post_id` = '{$_GET['post_id']}' ");
					$likes = mysqli_fetch_array($likes, MYSQLI_ASSOC);

					// Количество комментариев
					$comments = mysqli_query($link, "SELECT COUNT(id) as id FROM `comments` WHERE `post_id` = '{$_GET['post_id']}' ");
					$comments = mysqli_fetch_array($comments, MYSQLI_ASSOC);

					?>
					<ul class="stats">
						<?php if (isset($_SESSION['user_id'])) {
							if ($_SESSION['user_id'] == $post['user_id']) { ?>
								<li><a href="./edit.php?edit_post_id=<?= $post['id'] ?>">Edit</a></li>
								<li><a href="./index.php?delete=<?= $post['id'] ?>" class="red">Delete</a></li>
								<li><a href="?post_id=<?= $post["id"] ?>&<?= $post['blocked'] == 0 ? 'blocked' : 'unlocked' ?>"
										class="red">
										<?= $post['blocked'] == 0 ? 'Blocked' : 'Unlocked' ?>
									</a></li>
								<?php
								if (isset($_GET["blocked"])) {
									$block_post = mysqli_query($link, "UPDATE `posts` SET `blocked` = '1' WHERE `id` = '{$_GET['post_id']}' ");
									header("Location: single.php?post_id=" . $_GET['post_id']);
								} elseif (isset($_GET['unlocked'])) {
									$unlock_post = mysqli_query($link, "UPDATE `posts` SET `blocked` = '0' WHERE `id` = '{$_GET['post_id']}' ");
									header("Location: single.php?post_id=" . $_GET['post_id']);
								}
								?>
							<?php }
						} ?>

						<li><a href="<?= isset($_SESSION['user_id']) ? '?post_id=' . $post["id"] . '&liked' : '#menu' ?>"
								class="icon fa-heart">
								<?= $likes['id'] ?>
							</a></li>
						<li><a href="#comm" class="icon fa-comment">
								<?= $comments['id'] ?>
							</a></li>
					</ul>
				</footer>
			</article>

			<!-- Comments -->
			<div class="post">
				<section class="comments">
					<h3 id="comm">Comments</h3>
					<form action="?post_id=<?= $post['id'] ?>" method="post">
						<textarea name='comment' style='resize: none;'></textarea><br>
						<h5 style="text-align: center; color: red;">
							<?= isset($untitled_comment) ? $untitled_comment : '' ?>
						</h5>
						<input type="submit" class="button big fit" value="Add Comment">
					</form>
				</section>

				<?php
				//Комментарии под постом
				$comment_post = mysqli_query($link, "SELECT user_id, comment FROM `comments` WHERE `post_id` = '{$_GET['post_id']}' ");
				if (mysqli_num_rows($comment_post) != 0) {
					while ($row = $comment_post->fetch_array()) {
						$userID = $row['user_id'];
						$user = mysqli_fetch_array(mysqli_query($link, "SELECT fullname, avatar FROM `users` WHERE `id` = '$userID' "), MYSQLI_ASSOC);
						?>
						<article class="comment">
							<div class="comment-autor">
								<a href="./user.php?author=<?= $post['user_id'] ?>"><img src="<?= $user['avatar'] ?>"></a>
								<a href="./user.php?author=<?= $post['user_id'] ?>">
									<?= $user['fullname'] ?>
								</a>
							</div>
							<p>
								<?= $row['comment'] ?>
							</p>
						</article>
						<?php
					}
				} else {
					?>
					<p style='text-align: center;'> Комментарии отсутствуют </p>
					<?php
				}
				?>
			</div>

		</div>

	</div>

	<!-- Footer -->
		<?php include 'include/footer.php' ?>
</body>

</html>