<?php
session_start();
include_once 'include/connect.php';
include 'include/head.php';
include 'include/post.php';
include 'include/script.php';
?>

<body>

	<!-- Wrapper -->
	<div id="wrapper">

		<!-- Header -->
		<?php include 'include/header.php'; ?>

		<!-- Menu -->
		<?php include 'include/menu.php'; ?>

		<div id="main">
			<!-- Post -->

			<?php
			if (isset($_GET['page'])) {
				$page = $_GET['page'];
				$posts = Post($page, $link);
			} else {
				$posts = Post(0, $link);
			}

			while ($row = $posts->fetch_array()) {
				$author = mysqli_query($link, "SELECT fullname, avatar FROM `users` WHERE `id` = '{$row['user_id']}' ");
				$author = mysqli_fetch_array($author, MYSQLI_ASSOC);
				uploadPost($row['id'], $row['user_id'], $row['header'], $row['subheader'], $row['datepost'], $row['anons'], $row['photo'], $author['fullname'], $author['avatar'], $row['countlike'], $row['countcomments']);
			}
			?>

			<!-- Pagination -->
			<?php
			$page_number = mysqli_fetch_array(mysqli_query($link, " SELECT COUNT(id) FROM `posts` "), MYSQLI_NUM) ?? 1;
			$i = $_GET["page"] ?? 0;
			?>
			<ul class="actions pagination">
				<li><a href="?page=<?= $i - 1 ?>"
						class="<?= $i - 1 < ceil($page_number[-1] / 3) ? 'disabled' : '' ?> button big previous">Previous Page</a></li>
				<li><a href="?page=<?= $i + 1 ?>"
						class="<?= $i + 1 > ceil($page_number[0] / 3) ? 'disabled' : '' ?>  button big next">Next
						Page</a></li>
			</ul>
		</div>

		<!-- Sidebar -->
		<section id="sidebar">

			<!-- Intro -->
			<section id="intro">
				<a href="#" class="logo"><img src="images/logo.jpg" alt="" /></a>
				<header>
					<h2>Blog</h2>
					<p>Be popular with us</p>
				</header>
			</section>

			<!-- Mini Posts -->
			<section>
				<h3>Popular posts</h3>
				<div class="mini-posts">

					<!-- Mini Post -->

					<?php

					$popular = mysqli_query($link, " SELECT p.id, p.user_id as userID, p.header, p.datepost, p.photo FROM (SELECT post_id, count(*)as vs from liked group by post_id) as v, posts p where
					v.post_id=p.id order by vs desc limit 4; ");
					while ($row = $popular->fetch_array()) {
						$pop_aut = mysqli_fetch_array(mysqli_query($link, " SELECT avatar FROM `users` WHERE `id` = '{$row['userID']}' "), MYSQLI_ASSOC);
						?>
						<article class="mini-post">
							<header>
								<h3><a href="single.php?post_id=<?= $row['id'] ?>">
										<?= $row['header'] ?>
									</a></h3>
								<time class="published" datetime="<?= $row['datepost'] ?>">
									<?= $row['datepost'] ?>
								</time>
								<a href="user.php?author=<?= $row['userID'] ?>" class="author"><img
										src="<?= $author['avatar'] ?>" alt="" /></a>
							</header>
							<a href="single.php?post_id=<?= $row['id'] ?>" class="image"><img src="<?= $row['photo'] ?>"
									alt="" /></a>
						</article>
						<?php
					}

					?>
				</div>
			</section>

			<!-- Posts List -->
			<section>

				<h3>Rating bloggers</h3>

				<ul class="posts">
					<?php
					$popularposts = mysqli_query($link, 'SELECT u.id, u.avatar, u.fullname,li.vs as likes,pos.vs as posts from users u,
					(select p.user_id,count(*)as vs from liked l,posts p where l.post_id=p.id group by
					p.user_id)as li,
					(select user_id,count(*)as vs from posts group by user_id)as pos
					where u.id=pos.user_id and li.user_id=u.id
					order by li.vs desc,pos.vs desc limit 5;');

					while ($row = $popularposts->fetch_array()) {
						?>
						<li>
							<article>
								<header>
									<h3><a href="user.php?author=<?= $row['id'] ?>">
											<?= $row['fullname'] ?>
										</a></h3>
									<span class="published">
										<?= $row['likes'] ?> likes in
										<?= $row['posts'] ?> posts
									</span>
								</header>
								<a href="user.php?author=<?= $row['id'] ?>" class="image"><img src="<?= $row['avatar'] ?>"
										alt="" /></a>
							</article>
						</li>
						<?php
					}
					?>
				</ul>
			</section>

			<!-- Footer -->
			<?php include 'include/footer.php'?>


		</section>

	</div>

</body>

</html>