<?php
// Загрузка постов
function uploadPost($post_id, $author_id, $header, $subheader, $datepost, $anons, $photo, $fullname, $avatar, $likes = 0, $comments = 0) 
{
    ?>
    <article class="post">
        <header>
            <div class="title">
                <h2><a href="single.php?post_id=<?= $post_id ?>"><?= $header ?></a></h2>
                <p><?= $subheader ?></p>
            </div>
            <div class="meta">
                <time class="published" datetime="<?= $datepost ?>"><?= $datepost ?></time>
                <a href="user.php?author=<?= $author_id ?>" class="author"><span class="name"><?= $fullname ?></span><img src="<?= $avatar ?>" alt="" /></a>
            </div>
        </header>
        <a href="single.php?post_id=<?= $post_id ?>" class="image featured"><img src="<?= $photo ?>" alt="" /></a>
        <p><?= $anons ?></p>
        <footer>
            <ul class="actions">
                <li><a href="single.php?post_id=<?= $post_id ?>" class="button big">Continue Reading</a></li>
            </ul>
            <ul class="stats">
                <li><a href="<?= isset($_SESSION['user_id']) ? isset($_GET['author']) ? 'user.php?author='.$author_id.'&post_id='.$post_id.'&liked' : 
                (isset($_GET['page']) ? 'index.php?page='.$_GET['page'].'&post_id='.$post_id.'&liked' : 
                'index.php?page=1&post_id='.$post_id.'&liked') : '#menu' ?>" class="icon fa-heart"><?= $likes ?></a></li>
                <li><a href="single.php?post_id=<?= $post_id ?>#comm" class="icon fa-comment"><?= $comments ?></a></li>
            </ul>
        </footer>
    </article>
    <?php
}

// Пагинация
function Post($pageN = 0, $conn) {
    $posts = mysqli_query($conn, 'SELECT p.id,p.header,p.subheader,p.photo,DATE_FORMAT(p.datepost, "%d.%m.%Y")
	datepost,anons, p.blocked, u.id as user_id,u.fullname,u.avatar,ifnull(ls.countlike,0)countlike,
	ifnull(c.countcomments,0)countcomments FROM `posts` p
	left join users u on p.user_id = u.id
	left join (select post_id,count(*)as countlike from liked group by post_id) ls on
	p.id=ls.post_id
	left join (select post_id,count(*)as countcomments from comments group by post_id) c on
	p.id=c.post_id
	order by id desc limit '.$pageN.', 3 ');
    return $posts;
}