<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\AbonentController;
use App\Http\Controllers\CalinaController;
use Illuminate\Support\Facades\Auth;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Route::get('/', function () {
//     return view('index');
// })->name('index');

Route::get('/login', [UserController::class, 'login'])->name('login');
Route::get('/register', [UserController::class, 'register'])->name('register');

Route::post('/createuser', [UserController::class, 'reg'])->name('createuser');
Route::post('/authuser', [UserController::class, 'auth'])->name('authuser');


Route::middleware('auth')->group(function () {
    Route::get('/logout', [UserController::class, 'logout'])->name('logout');
    Route::get('/tariff={trf}', [UserController::class, 'tariff'])->name('tariff');  
    Route::get('/account', [UserController::class, 'account'])->name('account');
    Route::get('/calinas={ab}', [CalinaController::class, 'calinas'])->name('calinas');
    Route::get('/calina', [CalinaController::class, 'calina'])->name('calina');
    Route::post('/call', [CalinaController::class, 'call'])->name('call');
    Route::get('/edit_abonent={ab}', [AbonentController::class, 'edit_abonent'])->name('edit_abonent');
    Route::post('/editabonent={ab}', [AbonentController::class, 'editabonent'])->name('editabonent'); 
}); 

Route::middleware('admin')->group(function () {
    Route::get('/abonents', [AdminController::class, 'abonents'])->name('abonents');
    Route::get('/addtariff', [AdminController::class, 'addtariff'])->name('addtariff');
    Route::post('/add_tariff', [AdminController::class, 'add_tariff'])->name('add_tariff');
    Route::get('/edit_tariff={trf}', [AdminController::class, 'edit_tariff'])->name('edit_tariff');
    Route::post('/edittariff={trf}', [AdminController::class, 'edittariff'])->name('edittariff');
    Route::get('/delete_tariff={trf}', [AdminController::class, 'delete_tariff'])->name('delete_tariff');
});

Route::get('/', [AdminController::class, 'tariffs'])->name('index');



