<x-head />

<body>

	<!-- Wrapper -->
	<div id="wrapper">
		<!-- Header -->
		<x-header />

		<!-- Menu -->
		<x-menu />

		<!-- Main -->
		<div id="main">
			@foreach ($users as $user)
			<!-- Post -->
			<article class="post">
				<header>
					<div class="title">
						<h2><a href="{{Route('post', $user->id)}}">{{$user->header}}</a></h2>
						<p>{{$user->subheader}}</p>
					</div>
					<div class="meta">
						<time class="published" datetime="2015-11-01">{{$user->datepost}}</time>
						<a href="{{Route('user', $user->user_id)}}" class="author"><span class="name">{{$user->user->fullname}}</span><img src="/blog_laravel/public/{{$user->user->avatar}}" alt="" /></a>
					</div>
				</header>
				<a href="{{Route('post', $user->id)}}" class="image featured"><img src="/blog_laravel/public/{{$user->photo}}" alt="" /></a>
				<p>{{$user->anons}}</p>
				<footer>
					<ul class="actions">
						<li><a href="{{Route('post', $user->id)}}" class="button big">Continue Reading</a></li>
					</ul>
					<ul class="stats">
						<li><a href="{{Route('likes', $user->id)}}" class="icon fa-heart">{{ $user->likes->count() }}</a></li>
						<li><a href="{{Route('post', $user->id)}}#comm" class="icon fa-comment">{{ $user->comments->count() }}</a></li>
					</ul>
				</footer>
			</article>
			@endforeach

			<!-- Pagination -->
			{{$users->links('vendor.pagination.simple-default')}}
			<!-- Footer -->
			<x-footer />
		</div>





	</div>

	<!-- Scripts -->
	<x-scripts />

</body>

</html>