<x-head />

<body>

    <!-- Wrapper -->
    <div id="wrapper">

        <!-- Header -->
        <x-header />

        <!-- Menu -->
        <x-menu />

        <!-- Main -->
        <div id="main">
            <!-- Post -->
            <article class="post">

                <header>
                    <div class="title">
                        <h2><a href="{{Route('post', $post->id)}}">
                                {{ $post->header }}
                            </a></h2>
                        <p>
                            {{ $post->subheader }}
                        </p>
                    </div>
                    <div class="meta">
                        <time class="published" datetime="{{ $post->datepost }}">
                            {{ $post->datepost }}
                        </time>
                        <a href="{{Route('user', $post->user_id)}}" class="author"><span class="name">
                                {{ $user->fullname }}
                            </span><img src="/blog_laravel/public/{{ $user->avatar }}" alt="Avatar of {{ $user->fullname }}" /></a>
                    </div>
                </header>
                <span class="image featured"><img src="/blog_laravel/public/{{ $post->photo }}" alt="" /></span>

                <p>
                    {{ $post->anons }}
                </p>

                <p>
                    {{ $post->post }}
                </p>
                <footer>
                    <?php
                    // Like::count('id');
                    // Comment::count('id');
                    ?>
                    <ul class="stats">
                        @if(Auth::id() == $post->user_id)
                        <li><a href="{{Route('edit', $post->id)}}">Edit</a></li>
                        <li><a href="{{Route('deletepost', $post->id)}}" class="red">Delete</a></li>
                        <li><a href="{{Route('blockpost', $post->id)}}" class="red">{{ $messageblock }}</a></li>
                        @endif
                        <li>
                            <a href="{{Route('likes', $post->id)}}" class="icon fa-heart">
                                {{ $likes->count() }}
                            </a>
                        </li>

                        <li>
                            <a href="#comm" class="icon fa-comment">
                                {{ $comments->count() }}
                            </a>
                        </li>
                    </ul>
                </footer>
            </article>
            <!-- Comments -->
            <div class="post">
                <section class="comments">
                    <h3 id="comm">Comments</h3>
                    <form action="{{Route('comments', $post->id)}}" method="post">
                        @csrf
                        <textarea name='comment' style='resize: none;'></textarea><br>
                        <h5 style="text-align: center; color: red;">
                            <?= isset($untitled_comment) ? $untitled_comment : '' ?>
                        </h5>
                        <input type="submit" name="addcomment" class="button big fit" value="Add Comment">
                    </form>
                    @error("comment")
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </section>

                @foreach ($comments as $comment)
                <article class="comment">
                    <div class="comment-autor">
                        <a href=""><img src="/blog_laravel/public/{{ $comment->user->avatar }}"></a>
                        <a href="">{{ $comment->user->fullname }}</a>
                    </div>
                    <p>
                        {{ $comment->comment }}
                    </p>
                </article>
                @endforeach
            </div>
        </div>

    </div>

    <!-- Footer -->
    <x-footer />
    <!-- Scripts -->
    <x-scripts />
</body>

</html>