<html>
<x-head />

<body>

	<!-- Wrapper -->
	<div id="wrapper">
		<!-- Header -->
		<x-header />

		<!-- Menu -->
		<x-menu />

		<!-- Main -->
		<div id="main">
			<!-- Post -->
			@foreach ($posts as $post)
			@if ($post->blocked != 1)
			<article class="post">
				<header>
					<div class="title">
						<h2><a href="{{Route('post', $post->id)}}">{{$post->header}}</a></h2>
						<p>{{$post->subheader}}</p>
					</div>
					<div class="meta">
						<time class="published" datetime="2015-11-01">{{$post->datepost}}</time>
						<a href="{{Route('user', $post->user_id)}}" class="author"><span class="name">{{$post->user->fullname}}</span><img src="/blog_laravel/public/{{$post->user->avatar}}" alt="" /></a>
					</div>
				</header>
				<a href="{{Route('post', $post->id)}}" class="image featured"><img src="/blog_laravel/public/{{$post->photo}}" alt="" /></a>
				<p>{{$post->anons}}</p>
				<footer>
					<ul class="actions">
						<li><a href="{{Route('post', $post->id)}}" class="button big">Continue Reading</a></li>
					</ul>
					<ul class="stats">
						<li><a href="{{Route('likes', $post->id)}}" class="icon fa-heart">{{ $post->likes->count() }}</a></li>
						<li><a href="{{Route('post', $post->id)}}#comm" class="icon fa-comment">{{ $post->comments->count() }}</a></li>
					</ul>
				</footer>
			</article>
			@endif
			@endforeach

			<!-- Pagination -->
			{{$posts->links('vendor.pagination.simple-default')}}

		</div>

		<!-- Sidebar -->
		<section id="sidebar">

			<!-- Intro -->
			<section id="intro">
				<a href="#" class="logos"><img src="/blog_laravel/public/images/logo.jpg" alt="" /></a>
				<header>
					<h2>Blog</h2>
					<p>Be popular with us</p>
				</header>
			</section>

			<!-- Mini Posts -->
			<section>
				<h3>Popular posts</h3>
				<div class="mini-posts">

					<!-- Mini Post -->
					@foreach ($popularposts as $popularpost)
					@if ($popularpost->blocked != 1)
					<article class="mini-post">
						<header>
							<h3><a href="{{Route('post', $post->id)}}">
									{{$popularpost->header}}
								</a></h3>
							<time class="published" datetime="{{$post->datepost}}">
								{{$popularpost->datepost}}
							</time>
							<a href="{{Route('user', $popularpost->user_id)}}" class="author"><img src="/blog_laravel/public/{{$popularpost->user->avatar}}" alt="" /></a>
						</header>
						<a href="{{Route('post', $popularpost->id)}}" class="image"><img src="/blog_laravel/public/{{$popularpost->photo}}" alt="" /></a>
					</article>
					@endif
					@endforeach
				</div>
			</section>

			<!-- Posts List -->
			<section>

				<h3>Rating bloggers</h3>
				<ul class="posts">
					@foreach ($popularusers as $popularuser)
					<li>
						<article>
							<header>
								<h3><a href="{{Route('user', $popularuser->id)}}">{{$popularuser->fullname}}</a></h3>
								<span class="published">{{$popularuser->userLikes->count()}} likes in {{$popularuser->userPosts->count()}} posts</span>
							</header>
							<a href="{{Route('user', $popularuser->id)}}" class="image"><img src="/blog_laravel/public/{{$popularuser->avatar}}" alt="" /></a>
						</article>
					</li>
					@endforeach
				</ul>
			</section>

			<!-- Footer -->
			<x-footer />

		</section>

	</div>

	<!-- Scripts -->
	<x-scripts />

</body>
<style>
	.logos {
    width: 6.5em;
    height: 6.5em;
    margin-right: 1%;
    display: inline-flex;
  clip-path: polygon(50% 0, 100% 25%, 100% 75%, 50% 100%, 0 75%, 0 25%);
}
</style>
</html>