<section id="menu">

    <!-- Actions -->
    @guest
    <section>
        <ul class="actions vertical">
            <li>
                <h3>Login</h3>
            </li>
            <li>
                <form action="{{Route('authuser')}}" method="post">
                    @csrf
                    <input type="text" name="login" placeholder="Login"><br>
                    <input type="password" name="password" placeholder="Password"><br>
                    <input type="submit" class="button big fit" value="Log In">
                </form>
                @error("login")
                <div class="alert alert-danger">{{ $message }}</div>
                @enderror
                @error("password")
                <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </li>

            <li>
                <h3>Registration</h3>
            </li>
            <li>
                <form action="{{Route('createuser')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <input type="text" name="fullnameReg" placeholder="Fullname"><br>
                    <input type="text" name="loginReg" placeholder="Login"><br>
                    <input type="password" name="passReg" placeholder="Password"><br>
                    <input type="file" name="avatar"><br><br>
                    <input type="submit" class="button big fit" value="Sign up">
                </form>
                @error("loginReg")
                <div class="alert alert-danger">{{ $message }}</div>
                @enderror
                @error("fullnameReg")
                <div class="alert alert-danger">{{ $message }}</div>
                @enderror
                @error("passReg")
                <div class="alert alert-danger">{{ $message }}</div>
                @enderror
                @error("avatarReg")
                <div class="alert alert-danger">{{ $message }}</div>
                @enderror
            </li>
        </ul>
    </section>
    @endguest

    @auth
    <section>
        <ul class="links">
            <li>
                <a href="{{Route('user', Auth::id())}}">
                    <h3>My page</h3>
                </a>
            </li>
            <li>
                <a href="{{Route('add')}}">
                    <h3>Add Post</h3>
                </a>
            </li>
            <li>
                <a href="{{Route('logout')}}">
                    <h3>Log Out</h3>
                </a>
            </li>
        </ul>
    </section>
    @endauth


</section>