<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;

class CheckAdminRole
{
    public function handle($request, Closure $next)
    {
        if(Auth::check()){
            if (Auth::user() && Auth::user()->role != 'admin') {
                return redirect()->route('index');
                
            }
            else{
                return $next($request);
            }
        }
        else{
            return redirect()->route('login');
        }
    }
}
