<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Storage;
use App\Http\Requests\authUserRequest;
use App\Http\Requests\create_user_request;
use App\Models\User;
use App\Models\Abonent;
use App\Models\Tariff;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class UserController extends Controller
{
    public function reg(create_user_request $request)
    {
        $user = new User();
        $user->name = $request->nameReg;
        $user->lastname = $request->lastReg;
        $user->number = $request->numberReg;
        $user->password = $request->passReg;
        $user->save();
        Auth::login($user);

        $ab = new Abonent();
        $ab->user_id = Auth::user()->id;
        $ab->tariff_id = 1;
        $ab->save();
        return redirect()->route('index');
        // $thatUser = User::where('id', $user->id)->get();

    }

    public function tariff(Tariff $trf) {
        $ab = Auth::id();
        $abonent = Abonent::where('user_id', $ab)->first();
        $abonent->tariff_id = $trf->id;
        $abonent->save();
        return redirect()->route('index');
    }

    public function auth(authUserRequest $request)
    {
        if (Auth::attempt(['number' => $request->number,  'password' => $request->password])) {
            // $request->session()->regenerate();
            return redirect()->route('index');
            // return redirect()->intended('dashboard');
        }
        else {
            return redirect()->route('login')->withErrors([
                'number' => 'Incorrect password',
            ]);
        }
    }

    public function account(Tariff $trf){
        // $trfs = Tariff::all();
        $id = Auth::id();
        $ab = Abonent::where('user_id', $id)->first();
        return view('account', ['ab' => $ab, 'trf' => $trf]);
    }

    public function login() {
        return view('login');
    }

    public function register(){
        return view('login');
    }

    public function logout(User $user) {
        Auth::logout($user);
        return redirect()->route('index');
    }

    public function header(Abonent $ab)
{
    $abonent = Abonent::find($ab); // Fetch the $abonent object here

    return view('header')->with('abonent', $abonent);
}
}
