<?php

namespace App\Http\Controllers;

use App\Http\Middleware\CheckAdminRole;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\create_call_request;
use App\Models\User;
use App\Models\Abonent;
use App\Models\Call;
use App\Models\Tariff;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CalinaController extends Controller
{
    public function calinas($ab){
        $calls = Call::where('abonent_id', $ab)->get();
        $abs = Abonent::all();
        $users = User::all();
        $trf = Tariff::all();
        return view('calinas', ['calls' => $calls, 'abs' => $abs, 'users' => $users, 'trf' => $trf]);
    }

    public function calina(){
            $trfs = Tariff::all();
            $ab = Auth::id();
            $ab = Abonent::where('user_id', $ab)->first();
            // $popularusers = User::all()->sortByDesc('userLikes')->take(5);
            // $comment = $posts->where('comment');
            return view('calina', ['trfs' => $trfs, 'ab' => $ab]);
    }

    public function call(create_call_request $request){
        $ab = Auth::id();
        $ab = Abonent::where('user_id', $ab)->first();
        $call = new Call();
        $call->abonent_id = $ab->id;
        $call->datecall = now();
        $call->timecall = gmdate("H:i:s", $request->timecall);
        $call->number = $request->numbercall;
        $call->notes = "OK";
        $call->price = $request->timecall * $ab->tariff->sprice;
        $call->save();
        return redirect()->route('calinas', $ab->id);
    }
}
