<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\add_tariff_request;
use App\Http\Requests\edit_tariff_request;
use App\Models\User;
use App\Models\Tariff;
use App\Models\Abonent;
use App\Models\Call;

class AdminController extends Controller
{
    public function abonents(){
        $abs = Abonent::all();
        $users = User::all();
        $trf = Tariff::all();
        $call = Call::all();
        return view('abonents', ['abs' => $abs, 'call' => $call, 'users' => $users, 'trf' => $trf]);
    }

    public function postindexAPI(User $userid) {
        // $posts = Post::all()->sortByDesc('created_at');
        $users = User::all();
        // $popularusers = User::all()->sortByDesc('userLikes')->take(5);
        // $comment = $posts->where('comment');
        return view('abonents', ['users' => $users,]);
    }

    public function addtariff(){
        return view('addtariff');
    }

    public function add_tariff(add_tariff_request $request){
        $trf = new Tariff();
        $trf->name = $request->tname;
        $trf->sprice = $request->sprice;
        $trf->save();
        return redirect()->route('index');
    }

    public function edit_tariff(Tariff $trf){
        return view('addtariff', ['trf' => $trf]);
    }

    public function edittariff(edit_tariff_request $request, Tariff $trf){
        $trf->name = $request->tname;
        $trf->sprice = $request->sprice;
        $trf->save();
        return redirect()->route('index');
    }

    public function tariffs(){
        $trfs = Tariff::all();
        $abonent = Auth::id();
        $ab = Abonent::where('user_id', $abonent)->first();
        // $popularusers = User::all()->sortByDesc('userLikes')->take(5);
        // $comment = $posts->where('comment');
        return view('index', ['trfs' => $trfs, 'ab' => $ab]);
    }

    public function delete_tariff(Tariff $trf){
        if(Auth::user() && Auth::user()->role == 'admin'){
            $trf->delete();
            return redirect()->route('index');
        }
        else{
            return redirect()->route('index');
        }
    }
}
