<?php

namespace App\Http\Controllers;

use App\Http\Middleware\CheckAdminRole;
use Illuminate\Support\Facades\Storage;
use App\Http\Requests\authUserRequest;
use App\Http\Requests\create_user_request;
use App\Http\Requests\edit_abonent_request;
use App\Models\User;
use App\Models\Abonent;
use App\Models\Tariff;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AbonentController extends Controller
{
    public function tariff(Abonent $ab, Tariff $trf) {
        $ab->tariff_id = $trf->id;
        $ab->save();
        return redirect()->route('index');
    }

    public function register(){
        return view('login');
    }
    
    public function editabonent(edit_abonent_request $request, Abonent $ab){
        $ab->user->name = $request->nameEdit;
        $ab->user->lastname = $request->lastEdit;
        $ab->user->number = $request->numberEdit;
        $ab->tariff_id = $request->tariffEdit;
        $ab->user->save();
        $ab->save();  
        if(Auth::user() && Auth::user()->role == 'admin'){
            return redirect()->route('abonents');
        }
        else if(Auth::user()){
            return redirect()->route('account');
        }
        
    }

    public function edit_abonent(Abonent $ab){  
        $trfs = Tariff::all();
        return view('edit_abonent', ['ab' => $ab, 'trfs' => $trfs]);
    }

    public function logout(User $user) {
        Auth::logout($user);
        return redirect()->route('index');
    }
}
