let server = "http://localhost/blog_laravel/api/"
async function postData(route, method = "POST", data = {}){
    let myHeaders = new Headers();
    myHeaders.append("Accept", "application/json");

    if(localStorage.getItem("token"))
        myHeaders.append("Authorization", "Bearer " + localStorage.getItem("token"))




    let requestOptions = {
    method: method,
    headers: myHeaders,
    redirect: "follow"
    };
    if(method != "GET") {
        requestOptions.body = data;
    }

    let response = fetch(server + route, requestOptions)

    let resp = await response;
    if(resp.status == 401){
        localStorage.removeItem("token");
        location.reload();
    }

    return resp.json();
}

async function parseErrors(errors, formId){

    let all = document.querySelectorAll("#"+formId + " input,#"+formId + " textarea");
    all.forEach(el => {
        el.classList.remove("error")
    })
    all = document.querySelectorAll("#"+formId + ".red")
    all.forEach(el => {
        el.innerHTML = "";
    })

    if(errors) {
        let ob = Object.keys(errors);
        ob.forEach(elem => {
            let inp = document.querySelector('#'+formId + `[name="${elem}"]`);
            inp.classList.add('error');
            let red = document.querySelector('#'+formId + `[name="${elem}"]~.red`);
            red.innerHTML = errors[elem].join("<br>");
        })
    }
}

export default{
    postData,
    parseErrors,
    server,
    serverpublic,
}